/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_H
#define platform_H

/*
 * Platform specific stuff (in this case, for RISC OS)
 */

typedef short       Sixteen;/* At least 16 bit */
typedef signed long Value;  /* At least 32 bit */

#define PORT_MESSAGE "Ported to RISC OS by Marco Baye.\n"

/* Syntax message */
static char psUsage[] =
"Syntax: acme [-v] [-h] [-t] <file>\n"
"Options:\n"
"v(erbose)       Show some extra information\n"
"h(elp)          Show this message\n"
"t(hrowback)     Use throwback protocol of DDEUtils module\n\n";

/* Integer-to-character conversion routine */
#define PLATFORM_INT2CHAR(x)    \
  x ^= x >> 16;                 \
  x ^= x >>  8;                 \
  x &= 255

/* Character prefixing command line options */
#define PLATFORM_OPTIONPREFIX   '-'

/* Closedown sequence */
#define PLATFORM_EXIT   FN_Platform_Exit()

/* Convert UNIX-style pathname to system-style pathname */
#define PLATFORM_CONVERTPATH(a) FN_Platform_ConvertPath(a)

/* Platform specific message output */
#define PLATFORM_FN_MESSAGE(a, b)       FN_Platform_Message(a, b)

/* Maximum length of filenames in sources */
#define LNFMAX          255

/* Maximum length of paths */
#define LNPMAX          255

/* Setting the created files' types */
#define PLATFORM_SETFILETYPE(a, b)      FN_Platform_SetType(a, b);

/* Platform specific command line switches */
#define PLATFORM_SWITCHES       \
  case 't':                     \
  ffPlatform |= FUSETHROWBACK;  \
  break;

/* File types used */
#define FILETYPE_TEXT   0xfff
#define FILETYPE_CBM    0x064

/* Bitflags for "ffPlatform" */
static int ffPlatform = 0;/* Used to store platform-specific flags */

/* If set, use throwback protocol */
#define FUSETHROWBACK   (1u << 0)
/* If set, throwback is active */
#define FTHROWBACKON    (1u << 1)

/* DDEUtils message types */
#define DDEUTILS_WARNING        0
#define DDEUTILS_ERROR          1
#define DDEUTILS_SERIOUS        2

/* SWIs */
#define  OS_FILE                        0x00008
#define  DDEUTILS_THROWBACKEND          0x42589
#define  DDEUTILS_THROWBACKSEND         0x42588
#define  DDEUTILS_THROWBACKSTART        0x42587
#define XDDEUTILS_THROWBACKEND          0x62589
#define XDDEUTILS_THROWBACKSEND         0x62588
#define XDDEUTILS_THROWBACKSTART        0x62587

/*
 * Prototypes
 */
static void FN_Platform_FindLib(void);
static void FN_Platform_ConvertPath(char *);
static void FN_Platform_SetType(char *, int);
static void FN_Platform_Message(char *, int);
static void FN_Platform_Exit(void);

#endif
